## DeepSeek 本地部署教程

> 建议观看视频版教程：[https://www.bilibili.com/video/BV1KYwoevEit](https://www.bilibili.com/video/BV1KYwoevEit)

### 写在前面

最近`DeepSeek`太火了，以至于每个小伙伴都想试试。`DeepSeek` 的到来可谓是开启了全民AI热潮。

本以为`DeepSeek`本地化部署有多难，实际上验证后很简单，操作起来就像给电脑装个新软件那么简单，大约十多分钟可完成本地部署。

今天咱们来聊聊如何在自己的电脑上本地部署 `DeepSeek-R1-1.5B` 模型。

### 一、为啥要部署 DeepSeek-R1-1.5B？

在做的小伙伴可能跟我一样在使用`DeepSeek`时，经常遇到“服务器繁忙，请稍后再试。”

![img](https://pic.yupi.icu/yuyi/1739500169839-0d09c924-8509-4729-975d-c92d097489ed.png)

先说说为啥我推荐这个版本吧。`DeepSeek-R1-1.5B` 是一个轻量级的模型，参数量只有 15 亿，听起来是不是很“迷你”？但别小瞧了它，这可是个“小而精”的家伙。它只需要 3GB 的显存就能运行，这意味着即使你的电脑配置不高，也能轻松驾驭它。而且，它在数学推理方面表现相当出色，甚至在某些基准测试中超过了 `GPT-4o` 和 `Claude 3.5`。当然了，如果你电脑配置更高，可以尝试其他版本。

### 二、DeepSeek 不同版本模型硬件要求

以下是 DeepSeek 不同版本模型的硬件要求，小伙伴们可以结合自己电脑配置选择版本

| **模型版本**         | **参数量** | **显存需求（FP16）**                                 | **推荐 GPU（单卡）**                 | **多卡支持** | **量化支持** | **适用场景**                                                             |
| -------------------- | ---------- | ---------------------------------------------------- | ------------------------------------ | ------------ | ------------ | ------------------------------------------------------------------------ |
| **DeepSeek-R1-1.5B** | 15亿       | 3GB                                                  | GTX 1650（4GB显存）                  | 无需         | 支持         | 低资源设备部署（树莓派、旧款笔记本）、实时文本生成、嵌入式系统           |
| **DeepSeek-R1-7B**   | 70亿       | 14GB                                                 | RTX 3070/4060（8GB显存）             | 可选         | 支持         | 中等复杂度任务（文本摘要、翻译）、轻量级多轮对话系统                     |
| **DeepSeek-R1-8B**   | 80亿       | 16GB                                                 | RTX 4070（12GB显存）                 | 可选         | 支持         | 需更高精度的轻量级任务（代码生成、逻辑推理）                             |
| **DeepSeek-R1-14B**  | 140亿      | 32GB                                                 | RTX 4090/A5000（16GB显存）           | 推荐         | 支持         | 企业级复杂任务（合同分析、报告生成）、长文本理解与生成                   |
| **DeepSeek-R1-32B**  | 320亿      | 64GB                                                 | A100 40GB（24GB显存）                | 推荐         | 支持         | 高精度专业领域任务（医疗/法律咨询）、多模态任务预处理                    |
| **DeepSeek-R1-70B**  | 700亿      | 140GB                                                | 2x A100 80GB/4x RTX 4090（多卡并行） | 必需         | 支持         | 科研机构/大型企业（金融预测、大规模数据分析）、高复杂度生成任务          |
| **DeepSeek-671B**    | 6710亿     | 512GB+（单卡显存需求极高，通常需要多节点分布式训练） | 8x A100/H100（服务器集群）           | 必需         | 支持         | 国家级/超大规模 AI 研究（气候建模、基因组分析）、通用人工智能（AGI）探索 |

### 三、硬件配置

- **CPU**：AMD Ryzen 7 5800H with Radeon Graphics 3.20 GHz
- **内存**：16GB
- **操作系统**：Windows 11
- **硬盘空间**：500G，剩余335G

![img](https://pic.yupi.icu/yuyi/1739500608629-9b0369ee-f4fd-4bc9-90df-d4788dd0c649.png)

### 四、部署步骤

#### 4.1 下载并安装Ollama

访问官网：https://ollama.com/ 下载

![img](https://pic.yupi.icu/yuyi/1739502355751-4eed027b-d4e2-4f06-8550-404816abdb30.png)

安装文件OllamaSetup.exe大约745MB。

注：如果下载过于缓慢可以使用**迅雷之类的加速下载**；(将软件打包放网盘了，有需要的小伙伴可在文章末尾自取)

双击**OllamaSetup.exe进行。**

#### 4.2 检验Ollama是否安装成功

命令行输入 ollama -v 命令，出现版本号说明安装成功

#### 4.3 通过 Ollama 拉取 DeepSeek 模型

这里我选择是的**1.5b**，整个模型大小**1.1 GB**。

- **1.5B**：适用于轻量级任务，如边缘设备（如智能手表、物联网设备）上的简单交互、小型智能问答系统等。目前开源的最小版本。
- **671B**：主要用于大规模云端推理，适合科研分析、数据挖掘等需要处理海量数据的复杂任务。目前开源的最强版本

更多版本可以在这里查看：[**https://ollama.com/library/deepseek-r1**](https://ollama.com/library/deepseek-r1) 。

![img](https://pic.yupi.icu/yuyi/1739500260448-da177880-f5ca-4434-8593-eb6d47b7ecf2.png)

命令行输入：`ollama run deepseek-r1:1.5b` 拉取`DeepSeek`模型

整个拉取过程还是比较丝滑的，5到6分钟后看到【success】字样，代表成功安装DeepSeek R1，然后就可以与DeepSeek对话了

![img](https://pic.yupi.icu/yuyi/1739502407731-febeac44-4ab6-4dee-802a-24a73e057821.png)

#### 4.4 与DeepSeek对话

通过上面步骤之后，我们就可以愉快的与Deep Seek对话了，如输入：程序员如何避免35岁焦虑？

#### 4.5 安装WebUI

使用命令提示符与`DeepSeek`对话并不友好，为了更好的体验，我们可以安装`WebUI`，这里使用的是浏览器插件：**Page Assit**

（如果小伙伴找不到在哪下载`Page Assit`插件，打包放网盘了，可在文章末尾自取）

**启动ollama服务后，输入快捷键【ctrl + shift+L】快捷键即可打开WebUI页面**

刚安装`Page Assit` 插件， 需要进行一下如下设置

![img](https://pic.yupi.icu/yuyi/1739500677293-6b6c9402-a49e-471f-9624-e4dca16d4819.png)

设置完成后，选择模型就可以与`DeepSeek`对话了

![img](https://pic.yupi.icu/yuyi/1739500672402-fb3e55d6-f5ca-4184-afd9-55e0834c4c12.png)

### 五、实际应用场景：DeepSeek-R1-1.5B 能干啥？

别看 DeepSeek-R1-1.5B 体积小，它可一点都不“弱”。它非常适合用在一些轻量级的任务上，比如：

- **智能客服**：在小型企业或者个人项目中，它可以快速回答客户的一些常见问题，提高服务效率。
- **语言学习**：你可以用它来练习语言表达，比如输入一个中文句子，让它生成英文翻译。
- **创意写作**：如果你是个作家或者文案策划，它可以帮你快速生成一些创意片段或者文案初稿

### 六、小结

小伙伴们，是不是觉得本地部署 DeepSeek-R1-1.5B 模型超简单？只要按照上面的步骤操作，你就能让自己的电脑拥有一个“智能助手”。

而且，这个模型不仅运行速度快，还能在很多场景中发挥大作用。快去试试吧！

DeepSeek本地部署相关软件下载：

通过网盘分享的文件：DeepSeek本地部署软件.zip
链接: https://pan.baidu.com/s/1gQp1hJ2cTisfcd0hJcO9gw?pwd=ip55 提取码: ip55

本期内容到这儿就结束了，希望对您有所帮助。

我们下期再见 ヾ(•ω•`)o (●'◡'●)



> 来源：https://www.cnblogs.com/xiezhr/p/18712410